document.addEventListener('DOMContentLoaded', function() {
    // Hide the button connectino on loading
    $('.btn-connect').hide();

    /**
     * Get the settings from the json text file
     * then create the images based on the path
     * then apply the css rules to it
     */
    fetch('appsettings.json')
        .then(response => response.json())
        .then(data => {
            const numberOfImages = data.numberOfImages;
            const imageTimeout = data.imageTimeout || 1000;
            const imageFolder = 'images/';
            const carousel = document.querySelector('.featured-carousel.carousel');
            const thumbnailList = document.querySelector('.thumbnail');

            // FOR IMAGES
            for (let i = 1; i <= numberOfImages; i++) {
                const imageUrl = `${imageFolder}image${i}.jpg`;

                const item = document.createElement('div');
                item.className = 'item';

                const work = document.createElement('div');
                work.className = 'work';

                const imgDiv = document.createElement('div');
                imgDiv.className = 'img d-flex align-items-center justify-content-center';
                imgDiv.style.backgroundImage = `url(${imageUrl})`;
                imgDiv.style.backgroundSize = 'contain'; // Set background-size to contain
                imgDiv.style.backgroundPosition = 'center'; // Set background-position to center

                // IF YOU WANT TEXT ON THE MIDDLE
                // const text = document.createElement('div');
                // text.className = 'text text-center';
                // const heading = document.createElement('h2');
                // heading.textContent = `Slide ${i}`;
                // text.appendChild(heading);

                // imgDiv.appendChild(text);
                work.appendChild(imgDiv);
                item.appendChild(work);
                carousel.appendChild(item);
            }

            // Re-initialize the Owl Carousel after adding items
            $('.featured-carousel.carousel').owlCarousel('destroy');
            $('.featured-carousel.carousel').owlCarousel({
                items: 1,
                loop: false,
                margin: 0,
                autoplay: true,
                autoplayTimeout: imageTimeout,
                autoplayHoverPause: true,
                dots: false,
                nav: false
            }).on('changed.owl.carousel', function(event) {
                const currentSlideIndex = event.item.index;
                thumbnailList.querySelectorAll('li').forEach((item, index) => {
                    item.classList.toggle('active', index === currentSlideIndex);
                });
                
                // SETTING THE BUTTON CONNECT TO BE SHOWN OR NOT
                if (event.item.index === event.item.count - 1) {
                    console.log("enabled");
                    $('.btn-connect').show();
                } else {
                    console.log("disabled");
                    $('.btn-connect').hide();
                }
            });

            // FOR THUMBNAIL CREATION
            for (let i = 1; i <= numberOfImages; i++) {
                const imageUrl = `${imageFolder}image${i}.jpg`;

                const listItem = document.createElement('li');
                listItem.className = i === 1 ? 'active img' : 'img';

                const link = document.createElement('a');
                // link.href = '#';

                const image = document.createElement('img');
                image.src = imageUrl;
                image.alt = `Image ${i}`;
                image.className = 'img-fluid';

                link.appendChild(image);
                listItem.appendChild(link);
                thumbnailList.appendChild(listItem);
            }

        })
        .catch(error => {
            console.error('Error loading appsettings.json:', error);
        });
});
